import { IAComponentProps, AComponent, IAComponentState } from '../../acomponent';

export interface IFormElementValidator {
    /**
     * Specify if a value is required for this Form Element
     */
    required: string;
}

export interface IFormElementProps extends IAComponentProps {

}
export interface IFormElementState extends IAComponentState {
    /**
     * Error is some validators fail
     */
    error: string;
}

/**
 * Based component for all Form Element
 */
export abstract class AFormElement<P extends IFormElementProps, S extends IFormElementState> extends AComponent<P, S> {
    public constructor(props: P) {
        super(props);
    }

    protected getInitState(state: S) {
        return Object.assign({
            error: ''
        } as IFormElementState, state);
    }

    /**
     * Check if the Element is valid
     */
    public abstract isValid(): boolean;
}

export default AFormElement;
