import { IAComponentProps, AComponent, IAComponentState } from '../../../../acomponent';

export interface IButtonRadioItem {
    /**
     * Value of the Radio element
     */
    value?: string;
    /**
     * Displayed label for Radio Element
     */
    label?: string;
}

export interface IButtonRadioProps extends IAComponentProps {
    /**
     * List of Radio Button Item to display
     */
    items: Array<IButtonRadioItem>;
    /**
     * Default selected item. Should be the value of the item or its label if its value is not provided. Default: the first item will be selected.
     */
    selected?: string;
    /**
     * Callback if user select a new item.
     */
    onSelectItem?: (item: IButtonRadioItem) => void;
}
export interface IButtonRadioState extends IAComponentState {
}

/**
 * Form Button Radio. Radio input is masked to just let a button to manage state of radio.
 */
export abstract class ButtonRadio extends AComponent<IButtonRadioProps, IButtonRadioState> {
    public constructor(props: IButtonRadioProps) {
        super(props);
    }

    protected getInitState(state: IButtonRadioState) {
        return state;
    }

    /**
     * Callback when user select an item
     * @param item Selected item
     */
    protected onSelectButton(item: IButtonRadioItem) {
        if (this.props.onSelectItem) {
            this.props.onSelectItem(item);
        }
    }
}
