import * as React from 'react';
import { reactcomponent } from '../../../../@decorators/react';
import { FilteredList } from './filtered';

export class FilteredBaseList extends FilteredList {
    @reactcomponent()
    render() {
        return (
            <ul>
                {this.props.items.map(
                    (item, index) => <li
                        className={this.props.selectedIndex === index ? 'selected' : ''}
                        onMouseDown={(e) => this.onClick(e)}
                        onClick={() => this.onSelect(item)}
                        onTouchStart={(e) => {
                            this.onReserve(item);
                            this.onOver(index);
                        }}
                        onTouchMove={(e) => this.onTouchMove(e)}
                        onTouchEnd={(e) => {
                            this.onTrySelect(item);
                            this.onClick(e);
                        }}
                        key={`fl-${item.name}`}
                        onMouseOver={() => this.onOver(index)}
                        ref={this.props.selectedIndex === index ? this.selectedItem : ''}
                    >{item.name}</li>
                )}
            </ul>
        );
    }
}

export default FilteredBaseList;
