import * as React from 'react';
import { reactcomponent } from '../../../@decorators/react';
import { IDeal } from '../../../../shared/models/deals';
import { ResultPage } from './result';


const CurrencyMap: {
    [currency: string]: string;
} = {
    EUR: '€',
    USD: '$'
};

export class ResultBasePage extends ResultPage {
    private renderLoader() {
        return (
            <div className='loader'><i {...{ icon: 'loader-blue' } as any}></i></div>
        );
    }

    private renderPrice(step: IDeal) {
        if (step.discount) {
            return (
                <span><s>{step.cost}{CurrencyMap[this.state.currency]}</s> {step.cost * (100 - step.discount) / 100}{CurrencyMap[this.state.currency]}</span>
            );
        }
        return (
            <span>{step.cost}{CurrencyMap[this.state.currency]}</span>
        );
    }

    private renderResult() {
        return [
            <ul key='result'>
                {this.state.stepItems.map(step => {
                    return (
                        <li key={`${step.departure}-${step.arrival}`}>
                            <div>
                                {step.departure} > {step.arrival}
                                <p>{step.transport} {step.reference} for {`${step.duration.h}:${step.duration.m}`}</p>
                            </div>
                            <div>
                                {this.renderPrice(step)}
                            </div>
                        </li>
                    );
                })}
                <li>
                    <span>Total</span>
                    <span>{`${this.state.totalDeal!.duration.h}:${this.state.totalDeal!.duration.m}`}</span>
                    <span>{this.state.totalDeal!.cost}{CurrencyMap[this.state.currency]}</span>
                </li>
            </ul>,
            <button type='submit' key='action' onClick={() => this.onReset()}><i {...{ icon: 'reset-white' } as any}></i>Reset</button>
        ];
    }

    @reactcomponent(false, 'page')
    public render() {
        return (
            <div>
                {this.state.isLoading ? this.renderLoader() : this.renderResult()}
            </div>
        );
    }
}

export default ResultBasePage;
