import { IAComponentProps, IAComponentState, AComponent } from '../../acomponent';
import { IDeal, ITotalDeal } from '../../../../shared/models/deals';
import DirectionSingleton from '../../../services/direction';

export interface IResultPageProps extends IAComponentProps {
    /**
     * City from
     */
    departure: string;
    /**
     * City to
     */
    arrival: string;
    /**
     * Optimize search by
     */
    mode: 'cost'|'duration';

    /**
     * Callback to go back to search form
     */
    onReset?: () => void;
}

export interface IResultPageState extends IAComponentState {
    /**
     * List of each step
     */
    stepItems: Array<IDeal>;
    /**
     * Summary of the direction
     */
    totalDeal?: ITotalDeal;
    /**
     * If true, waiting for result
     */
    isLoading: boolean;
    /**
     * Current currency of price
     */
    currency: string;
}

/**
 * Result page
 */
export class ResultPage extends AComponent<IResultPageProps, IResultPageState> {
    public constructor(props: IResultPageProps) {
        super(props);
    }

    protected getInitState(state: IResultPageState) {
        return Object.assign({
            stepItems: [],
            isLoading: true,
            currency: ''
        } as IResultPageState, state);
    }

    /**
     * Trigger navigation to Search form
     */
    protected onReset() {
        if (this.props.onReset) {
            this.props.onReset();
        }
    }

    public componentDidMount() {
        super.componentDidMount();
        DirectionSingleton
            .find(this.props.departure, this.props.arrival, this.props.mode)
            .then(direction => {
                this.safeSetState({
                    stepItems: direction.steps,
                    totalDeal: direction.total,
                    isLoading: false,
                    currency: direction.currency
                });
            });
    }
}

export default ResultPage;
