import { IAdapter } from './adapters/IAdapter';

/**
 * Base class for all service
 */
export abstract class AService<T = {}> {
    private _adapter: IAdapter|null;
    public constructor() {
        this._adapter = null;
    }

    /**
     * Fetch Object/Entity
     * @param args Parameters of Object/Entity to fetch
     */
    public abstract find(...args: Array<string>): Promise<T>;

    /**
     * Set a new Service Adapter
     * @param adapter Service Adapter
     */
    public setAdapter(adapter: IAdapter) {
        this._adapter = adapter;
    }
    /**
     * Get current adapter
     */
    protected get adapter(): IAdapter {
        return this._adapter!;
    }

}

export default AService;
