import { AService } from './AService';
import { ICity, ICityOrdered } from '../../shared/models/cities';
import ECommand from '../../shared/ECommand';

/**
 * Autocomplete Service
 */
export class Autocomplete extends AService<Set<ICityOrdered>> {
    /**
     * Get list of city
     * @param cityName Full/Partial city name to fetch
     */
    public find(cityName: string) {
        return this.adapter.fetch<Set<ICityOrdered>>(ECommand.Autocomplete, [cityName]);
    }
}

const AutocompleteSingleton = new Autocomplete();
export default AutocompleteSingleton;
