import { AService } from './AService';
import ECommand from '../../shared/ECommand';
import { IDirection } from '../../shared/models/directions';

/**
 * Direction service
 */
export class Direction extends AService<IDirection> {
    /**
     * Get best direction
     */
    public find(cityFrom: string, cityTo: string, method: string) {
        return this.adapter.fetch<IDirection>(ECommand.Direction, [cityFrom, cityTo, method]);
    }
}

const DirectionSingleton = new Direction();
export default DirectionSingleton;
