"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var cities_1 = __importDefault(require("../resources/cities"));
// Paris
// paris|
// .?aris|.?.?ris|.?a.?is|.?ar.?s|.?ari.?|
// p.?ris|p.?.?is|p.?r.?s|p.?ri.?|
// pa.?is|pa.?.?s|pa.?i.?|
// par.?s|par.?.?|
// pari.?
function tokenize(content, maxDepth, depth) {
    if (depth === void 0) { depth = 0; }
    if (depth >= maxDepth) {
        return [content];
    }
    var result = [];
    var _loop_1 = function (i, max) {
        if (!i) {
            result.push(content);
        }
        else {
            var prefix_1 = content.substr(0, i - 1);
            tokenize(content.substr(i), maxDepth, depth + 1).forEach(function (suffix) { return result.push(prefix_1 + ".?" + suffix); });
        }
    };
    for (var i = 0, max = content.length; i <= max; ++i) {
        _loop_1(i, max);
    }
    return result;
}
var Autocomplete = /** @class */ (function () {
    function Autocomplete(fuzziness) {
        if (fuzziness === void 0) { fuzziness = 2; }
        this.fuzziness = fuzziness;
    }
    Autocomplete.prototype.execute = function (cityName) {
        var _this = this;
        return new Promise(function (resolve, reject) {
            var regExp = new RegExp("(" + tokenize(cityName, _this.fuzziness).join('|') + ")", 'i');
            cities_1.default.find(regExp)
                .then(resolve)
                .catch(reject);
        });
    };
    return Autocomplete;
}());
exports.Autocomplete = Autocomplete;
//# sourceMappingURL=autocomplete.js.map