import { IDeal } from '../../shared/models/deals';

export type TCurrency = 'EUR' | 'USD';

export interface IDatabase {
    /**
     * Current currency of data
     */
    currency: TCurrency;
    /**
     * List of Deals
     */
    deals: Array<IDeal>;
}

/**
 * Base class of Database
 */
export abstract class Database<T, P> {
    private static dataInstance: Promise<IDatabase>;
    private static loadInstance(): void {
        Database.dataInstance = new Promise<IDatabase>(async (resolve, reject) => {
            try {
                const data = await import('../../data/response.json');
                resolve(data as IDatabase);

                // resolve({} as any);
            } catch (e) {
                reject(e);
            }
        });
    }

    protected constructor() {
        Database.loadInstance();
        this.initialize();
    }

    /**
     * Get DB Adaptor
     */
    protected getDB(): Promise<IDatabase> {
        return Database.dataInstance;
    }

    /**
     * Initialize the resource service
     */
    protected abstract initialize(): void;

    /**
     * Fetch Object/Entity
     */
    public abstract find(params?: P): Promise<T>;
}

