import { lstatSync, readdirSync, Stats, readFileSync } from 'fs';

if (process.argv.length < 3) {
    console.log('Usage: node catscss.js <dir>|<file>');
    process.exit(-1);
}

const fileOrDirectory = process.argv.slice(2);

interface IFileStat {
    path: string;
    stats: Stats;
}

function isScss(file: IFileStat) {
    return file.stats.isDirectory() || file.path.split('.').pop() === 'scss';
}

function processDirectory(path: string) {
    const fileList = readdirSync(path);
    fileList.map(file => {
        return {
            path: path + '/' + file,
            stats: lstatSync(path + '/' + file)
        };
    }).filter(isScss).sort((a, b) => {
        if (a.stats.isDirectory() === b.stats.isDirectory()) {
            return a.path.toLowerCase().localeCompare(b.path.toLowerCase());
        }
        return a.stats.isDirectory() ? 1 : -1;
    }).map(file => file.path).forEach(processCat);
}

function processFile(path: string) {
    console.log(readFileSync(path, {
        encoding: 'utf-8'
    }));
}

function processCat(path: string) {
    const stats = lstatSync(path);
    if (stats.isDirectory()) {
        processDirectory(path);
    } else if (isScss({ path, stats })) {
        processFile(path);
    } else {
        console.warn(`Unknown: ${path}`);
    }
}

fileOrDirectory.forEach(processCat);
